<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1Part extends \Google\Model
{
  protected $codeExecutionResultType = GoogleCloudAiplatformV1CodeExecutionResult::class;
  protected $codeExecutionResultDataType = '';
  protected $executableCodeType = GoogleCloudAiplatformV1ExecutableCode::class;
  protected $executableCodeDataType = '';
  protected $fileDataType = GoogleCloudAiplatformV1FileData::class;
  protected $fileDataDataType = '';
  protected $functionCallType = GoogleCloudAiplatformV1FunctionCall::class;
  protected $functionCallDataType = '';
  protected $functionResponseType = GoogleCloudAiplatformV1FunctionResponse::class;
  protected $functionResponseDataType = '';
  protected $inlineDataType = GoogleCloudAiplatformV1Blob::class;
  protected $inlineDataDataType = '';
  protected $mediaResolutionType = GoogleCloudAiplatformV1PartMediaResolution::class;
  protected $mediaResolutionDataType = '';
  /**
   * Optional. The text content of the part. When sent from the VSCode Gemini
   * Code Assist extension, references to @mentioned items will be converted to
   * markdown boldface text. For example `@my-repo` will be converted to and
   * sent as `**my-repo**` by the IDE agent.
   *
   * @var string
   */
  public $text;
  /**
   * Optional. Indicates whether the `part` represents the model's thought
   * process or reasoning.
   *
   * @var bool
   */
  public $thought;
  /**
   * Optional. An opaque signature for the thought so it can be reused in
   * subsequent requests.
   *
   * @var string
   */
  public $thoughtSignature;
  protected $videoMetadataType = GoogleCloudAiplatformV1VideoMetadata::class;
  protected $videoMetadataDataType = '';

  /**
   * Optional. The result of executing the ExecutableCode.
   *
   * @param GoogleCloudAiplatformV1CodeExecutionResult $codeExecutionResult
   */
  public function setCodeExecutionResult(GoogleCloudAiplatformV1CodeExecutionResult $codeExecutionResult)
  {
    $this->codeExecutionResult = $codeExecutionResult;
  }
  /**
   * @return GoogleCloudAiplatformV1CodeExecutionResult
   */
  public function getCodeExecutionResult()
  {
    return $this->codeExecutionResult;
  }
  /**
   * Optional. Code generated by the model that is intended to be executed.
   *
   * @param GoogleCloudAiplatformV1ExecutableCode $executableCode
   */
  public function setExecutableCode(GoogleCloudAiplatformV1ExecutableCode $executableCode)
  {
    $this->executableCode = $executableCode;
  }
  /**
   * @return GoogleCloudAiplatformV1ExecutableCode
   */
  public function getExecutableCode()
  {
    return $this->executableCode;
  }
  /**
   * Optional. The URI-based data of the part. This can be used to include files
   * from Google Cloud Storage.
   *
   * @param GoogleCloudAiplatformV1FileData $fileData
   */
  public function setFileData(GoogleCloudAiplatformV1FileData $fileData)
  {
    $this->fileData = $fileData;
  }
  /**
   * @return GoogleCloudAiplatformV1FileData
   */
  public function getFileData()
  {
    return $this->fileData;
  }
  /**
   * Optional. A predicted function call returned from the model. This contains
   * the name of the function to call and the arguments to pass to the function.
   *
   * @param GoogleCloudAiplatformV1FunctionCall $functionCall
   */
  public function setFunctionCall(GoogleCloudAiplatformV1FunctionCall $functionCall)
  {
    $this->functionCall = $functionCall;
  }
  /**
   * @return GoogleCloudAiplatformV1FunctionCall
   */
  public function getFunctionCall()
  {
    return $this->functionCall;
  }
  /**
   * Optional. The result of a function call. This is used to provide the model
   * with the result of a function call that it predicted.
   *
   * @param GoogleCloudAiplatformV1FunctionResponse $functionResponse
   */
  public function setFunctionResponse(GoogleCloudAiplatformV1FunctionResponse $functionResponse)
  {
    $this->functionResponse = $functionResponse;
  }
  /**
   * @return GoogleCloudAiplatformV1FunctionResponse
   */
  public function getFunctionResponse()
  {
    return $this->functionResponse;
  }
  /**
   * Optional. The inline data content of the part. This can be used to include
   * images, audio, or video in a request.
   *
   * @param GoogleCloudAiplatformV1Blob $inlineData
   */
  public function setInlineData(GoogleCloudAiplatformV1Blob $inlineData)
  {
    $this->inlineData = $inlineData;
  }
  /**
   * @return GoogleCloudAiplatformV1Blob
   */
  public function getInlineData()
  {
    return $this->inlineData;
  }
  /**
   * per part media resolution. Media resolution for the input media.
   *
   * @param GoogleCloudAiplatformV1PartMediaResolution $mediaResolution
   */
  public function setMediaResolution(GoogleCloudAiplatformV1PartMediaResolution $mediaResolution)
  {
    $this->mediaResolution = $mediaResolution;
  }
  /**
   * @return GoogleCloudAiplatformV1PartMediaResolution
   */
  public function getMediaResolution()
  {
    return $this->mediaResolution;
  }
  /**
   * Optional. The text content of the part. When sent from the VSCode Gemini
   * Code Assist extension, references to @mentioned items will be converted to
   * markdown boldface text. For example `@my-repo` will be converted to and
   * sent as `**my-repo**` by the IDE agent.
   *
   * @param string $text
   */
  public function setText($text)
  {
    $this->text = $text;
  }
  /**
   * @return string
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * Optional. Indicates whether the `part` represents the model's thought
   * process or reasoning.
   *
   * @param bool $thought
   */
  public function setThought($thought)
  {
    $this->thought = $thought;
  }
  /**
   * @return bool
   */
  public function getThought()
  {
    return $this->thought;
  }
  /**
   * Optional. An opaque signature for the thought so it can be reused in
   * subsequent requests.
   *
   * @param string $thoughtSignature
   */
  public function setThoughtSignature($thoughtSignature)
  {
    $this->thoughtSignature = $thoughtSignature;
  }
  /**
   * @return string
   */
  public function getThoughtSignature()
  {
    return $this->thoughtSignature;
  }
  /**
   * Optional. Video metadata. The metadata should only be specified while the
   * video data is presented in inline_data or file_data.
   *
   * @param GoogleCloudAiplatformV1VideoMetadata $videoMetadata
   */
  public function setVideoMetadata(GoogleCloudAiplatformV1VideoMetadata $videoMetadata)
  {
    $this->videoMetadata = $videoMetadata;
  }
  /**
   * @return GoogleCloudAiplatformV1VideoMetadata
   */
  public function getVideoMetadata()
  {
    return $this->videoMetadata;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1Part::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1Part');
