<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataprocMetastore;

class GoogleCloudMetastoreV2Backup extends \Google\Collection
{
  protected $collection_key = 'restoringServices';
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $endTime;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string[]
   */
  public $restoringServices;
  protected $serviceRevisionType = GoogleCloudMetastoreV2Service::class;
  protected $serviceRevisionDataType = '';
  /**
   * @var string
   */
  public $state;

  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string[]
   */
  public function setRestoringServices($restoringServices)
  {
    $this->restoringServices = $restoringServices;
  }
  /**
   * @return string[]
   */
  public function getRestoringServices()
  {
    return $this->restoringServices;
  }
  /**
   * @param GoogleCloudMetastoreV2Service
   */
  public function setServiceRevision(GoogleCloudMetastoreV2Service $serviceRevision)
  {
    $this->serviceRevision = $serviceRevision;
  }
  /**
   * @return GoogleCloudMetastoreV2Service
   */
  public function getServiceRevision()
  {
    return $this->serviceRevision;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudMetastoreV2Backup::class, 'Google_Service_DataprocMetastore_GoogleCloudMetastoreV2Backup');
