<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseAppHosting;

class Config extends \Google\Collection
{
  protected $collection_key = 'env';
  protected $effectiveEnvType = EnvironmentVariable::class;
  protected $effectiveEnvDataType = 'array';
  protected $envType = EnvironmentVariable::class;
  protected $envDataType = 'array';
  protected $runConfigType = RunConfig::class;
  protected $runConfigDataType = '';

  /**
   * Output only. [OUTPUT_ONLY] This field represents all environment variables
   * employed during both the build and runtime. This list reflects the result
   * of merging variables from all sources (Backend.override_env,
   * Build.Config.env, YAML, defaults, system). Each variable includes its
   * `origin`
   *
   * @param EnvironmentVariable[] $effectiveEnv
   */
  public function setEffectiveEnv($effectiveEnv)
  {
    $this->effectiveEnv = $effectiveEnv;
  }
  /**
   * @return EnvironmentVariable[]
   */
  public function getEffectiveEnv()
  {
    return $this->effectiveEnv;
  }
  /**
   * Optional. Supplied environment variables for a specific build. Provided at
   * Build creation time and immutable afterwards. This field is only applicable
   * for Builds using a build image - (e.g., ContainerSource or ArchiveSource
   * with locally_built_source) Attempts to set this for other build types will
   * result in an error
   *
   * @param EnvironmentVariable[] $env
   */
  public function setEnv($env)
  {
    $this->env = $env;
  }
  /**
   * @return EnvironmentVariable[]
   */
  public function getEnv()
  {
    return $this->env;
  }
  /**
   * Optional. Additional configuration of the Cloud Run [`service`](https://clo
   * ud.google.com/run/docs/reference/rest/v2/projects.locations.services#resour
   * ce:-service).
   *
   * @param RunConfig $runConfig
   */
  public function setRunConfig(RunConfig $runConfig)
  {
    $this->runConfig = $runConfig;
  }
  /**
   * @return RunConfig
   */
  public function getRunConfig()
  {
    return $this->runConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Config::class, 'Google_Service_FirebaseAppHosting_Config');
