<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudConnectorsV1Destination extends \Google\Model
{
  /**
   * For publicly routable host.
   *
   * @var string
   */
  public $host;
  /**
   * Optional. The port is the target port number that is accepted by the
   * destination.
   *
   * @var int
   */
  public $port;
  /**
   * PSC service attachments. Format: projects/regions/serviceAttachments
   *
   * @deprecated
   * @var string
   */
  public $serviceAttachment;

  /**
   * For publicly routable host.
   *
   * @param string $host
   */
  public function setHost($host)
  {
    $this->host = $host;
  }
  /**
   * @return string
   */
  public function getHost()
  {
    return $this->host;
  }
  /**
   * Optional. The port is the target port number that is accepted by the
   * destination.
   *
   * @param int $port
   */
  public function setPort($port)
  {
    $this->port = $port;
  }
  /**
   * @return int
   */
  public function getPort()
  {
    return $this->port;
  }
  /**
   * PSC service attachments. Format: projects/regions/serviceAttachments
   *
   * @deprecated
   * @param string $serviceAttachment
   */
  public function setServiceAttachment($serviceAttachment)
  {
    $this->serviceAttachment = $serviceAttachment;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getServiceAttachment()
  {
    return $this->serviceAttachment;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudConnectorsV1Destination::class, 'Google_Service_Integrations_GoogleCloudConnectorsV1Destination');
