<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudConnectorsV1DestinationConfig extends \Google\Collection
{
  protected $collection_key = 'destinations';
  protected $destinationsType = GoogleCloudConnectorsV1Destination::class;
  protected $destinationsDataType = 'array';
  /**
   * Optional. The key is the destination identifier that is supported by the
   * Connector.
   *
   * @var string
   */
  public $key;

  /**
   * Optional. The destinations for the key.
   *
   * @param GoogleCloudConnectorsV1Destination[] $destinations
   */
  public function setDestinations($destinations)
  {
    $this->destinations = $destinations;
  }
  /**
   * @return GoogleCloudConnectorsV1Destination[]
   */
  public function getDestinations()
  {
    return $this->destinations;
  }
  /**
   * Optional. The key is the destination identifier that is supported by the
   * Connector.
   *
   * @param string $key
   */
  public function setKey($key)
  {
    $this->key = $key;
  }
  /**
   * @return string
   */
  public function getKey()
  {
    return $this->key;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudConnectorsV1DestinationConfig::class, 'Google_Service_Integrations_GoogleCloudConnectorsV1DestinationConfig');
