<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Networkconnectivity;

class RejectSpokeUpdateRequest extends \Google\Model
{
  /**
   * Optional. Additional information provided by the hub administrator.
   *
   * @var string
   */
  public $details;
  /**
   * Optional. A request ID to identify requests. Specify a unique request ID so
   * that if you must retry your request, the server knows to ignore the request
   * if it has already been completed. The server guarantees that a request
   * doesn't result in creation of duplicate commitments for at least 60
   * minutes. For example, consider a situation where you make an initial
   * request and the request times out. If you make the request again with the
   * same request ID, the server can check to see whether the original operation
   * was received. If it was, the server ignores the second request. This
   * behavior prevents clients from mistakenly creating duplicate commitments.
   * The request ID must be a valid UUID, with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   *
   * @var string
   */
  public $requestId;
  /**
   * Required. The etag of the spoke to reject update.
   *
   * @var string
   */
  public $spokeEtag;
  /**
   * Required. The URI of the spoke to reject update.
   *
   * @var string
   */
  public $spokeUri;

  /**
   * Optional. Additional information provided by the hub administrator.
   *
   * @param string $details
   */
  public function setDetails($details)
  {
    $this->details = $details;
  }
  /**
   * @return string
   */
  public function getDetails()
  {
    return $this->details;
  }
  /**
   * Optional. A request ID to identify requests. Specify a unique request ID so
   * that if you must retry your request, the server knows to ignore the request
   * if it has already been completed. The server guarantees that a request
   * doesn't result in creation of duplicate commitments for at least 60
   * minutes. For example, consider a situation where you make an initial
   * request and the request times out. If you make the request again with the
   * same request ID, the server can check to see whether the original operation
   * was received. If it was, the server ignores the second request. This
   * behavior prevents clients from mistakenly creating duplicate commitments.
   * The request ID must be a valid UUID, with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   *
   * @param string $requestId
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  /**
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }
  /**
   * Required. The etag of the spoke to reject update.
   *
   * @param string $spokeEtag
   */
  public function setSpokeEtag($spokeEtag)
  {
    $this->spokeEtag = $spokeEtag;
  }
  /**
   * @return string
   */
  public function getSpokeEtag()
  {
    return $this->spokeEtag;
  }
  /**
   * Required. The URI of the spoke to reject update.
   *
   * @param string $spokeUri
   */
  public function setSpokeUri($spokeUri)
  {
    $this->spokeUri = $spokeUri;
  }
  /**
   * @return string
   */
  public function getSpokeUri()
  {
    return $this->spokeUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RejectSpokeUpdateRequest::class, 'Google_Service_Networkconnectivity_RejectSpokeUpdateRequest');
