<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceNetworking;

class SecondaryIpRange extends \Google\Model
{
  /**
   * Secondary IP CIDR range in `x.x.x.x/y` format.
   *
   * @var string
   */
  public $ipCidrRange;
  /**
   * Name of the secondary IP range.
   *
   * @var string
   */
  public $rangeName;

  /**
   * Secondary IP CIDR range in `x.x.x.x/y` format.
   *
   * @param string $ipCidrRange
   */
  public function setIpCidrRange($ipCidrRange)
  {
    $this->ipCidrRange = $ipCidrRange;
  }
  /**
   * @return string
   */
  public function getIpCidrRange()
  {
    return $this->ipCidrRange;
  }
  /**
   * Name of the secondary IP range.
   *
   * @param string $rangeName
   */
  public function setRangeName($rangeName)
  {
    $this->rangeName = $rangeName;
  }
  /**
   * @return string
   */
  public function getRangeName()
  {
    return $this->rangeName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SecondaryIpRange::class, 'Google_Service_ServiceNetworking_SecondaryIpRange');
