<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ThreatIntelligenceService;

class MisconfigurationMetadata extends \Google\Collection
{
  protected $collection_key = 'references';
  /**
   * Optional. Description of the misconfiguration.
   *
   * @var string
   */
  public $description;
  /**
   * Optional. A user-friendly name for the misconfiguration.
   *
   * @var string
   */
  public $displayName;
  /**
   * Required. The identifier for the misconfiguration. This is an internal name
   * generated by the finding provider.
   *
   * @var string
   */
  public $misconfigurationId;
  protected $referencesType = MisconfigurationReference::class;
  protected $referencesDataType = 'array';
  /**
   * Optional. Recommended remediation steps for the misconfiguration.
   *
   * @var string
   */
  public $remediation;
  /**
   * Optional. The endpoint which was found to have the vulnerability.
   *
   * @var string
   */
  public $vulnerableUri;

  /**
   * Optional. Description of the misconfiguration.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Optional. A user-friendly name for the misconfiguration.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Required. The identifier for the misconfiguration. This is an internal name
   * generated by the finding provider.
   *
   * @param string $misconfigurationId
   */
  public function setMisconfigurationId($misconfigurationId)
  {
    $this->misconfigurationId = $misconfigurationId;
  }
  /**
   * @return string
   */
  public function getMisconfigurationId()
  {
    return $this->misconfigurationId;
  }
  /**
   * Optional. References to external resources that provide more information
   * about the misconfiguration.
   *
   * @param MisconfigurationReference[] $references
   */
  public function setReferences($references)
  {
    $this->references = $references;
  }
  /**
   * @return MisconfigurationReference[]
   */
  public function getReferences()
  {
    return $this->references;
  }
  /**
   * Optional. Recommended remediation steps for the misconfiguration.
   *
   * @param string $remediation
   */
  public function setRemediation($remediation)
  {
    $this->remediation = $remediation;
  }
  /**
   * @return string
   */
  public function getRemediation()
  {
    return $this->remediation;
  }
  /**
   * Optional. The endpoint which was found to have the vulnerability.
   *
   * @param string $vulnerableUri
   */
  public function setVulnerableUri($vulnerableUri)
  {
    $this->vulnerableUri = $vulnerableUri;
  }
  /**
   * @return string
   */
  public function getVulnerableUri()
  {
    return $this->vulnerableUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MisconfigurationMetadata::class, 'Google_Service_ThreatIntelligenceService_MisconfigurationMetadata');
